﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Text;
using System.Xml;
using System.Windows.Forms;
using System.Text.RegularExpressions;
using PI.FM.N000.Base.WinForms.Ribbon;
using Gemini.Core.WinForms.Controls.Type;
using Gemini.Core.WinForms.Controls.Interface;
using Gemini.Core.WinForms.Base;


namespace PI.ZB.N1200.ELearning.WinForms.AdvancedLevel
{
    public partial class UCAdvancedLevelDetails : PI.FM.N000.Base.WinForms.Controls.UCBODetails<BL.BO.AdvancedLevel, BL.BO.AdvancedLevel.Search>
    {
        private const int _IndexTabInstructor = 0;
        protected     int _IndexTabSystemInformation        = 1;
        private PI.ZB.N1200.ELearning.BL.ZSBELearning _blZSBELearning = null;

        private UCTabAdvancedLevelDetails _tabAdvancedLevelDetails = null;

        public UCTabAdvancedLevelDetails TabAdvancedLevelDetails
        {
            get
            {
                if (_tabAdvancedLevelDetails == null)
                {
                    _tabAdvancedLevelDetails = new UCTabAdvancedLevelDetails();
                }
                return _tabAdvancedLevelDetails;
            }
        }

        internal PI.ZB.N1200.ELearning.BL.ZSBELearning BLZSBELearning
        {
            get
            {
                if (_blZSBELearning == null)
                {
                    _blZSBELearning = new PI.ZB.N1200.ELearning.BL.ZSBELearning(Environment);
                }
                return _blZSBELearning;
            }
        }

        protected int IndexTabSystemInformation
        {
            set
            {
                _IndexTabSystemInformation = value;
            }
            get
            {
                return _IndexTabSystemInformation;
            }
        }

        public UCAdvancedLevelDetails()
        {
            InitializeComponent();

            AddStandardControlTabs();
            MinimumHorizontalSize = 400;
            MinimumVerticalSize = 190;
        }

        protected void AddStandardControlTabs()
        {
            this.AddControlAtTab(_IndexTabInstructor, TabAdvancedLevelDetails, "Ustawienia");
            this.AddControlAtTab(_IndexTabSystemInformation     , TabSystemInformation      , "Informacje systemowe");
        }

        public override void Initialize(Gemini.Core.WinForms.Interface.IPlugIn ParentPlugIn, Gemini.Core.WinForms.Interface.IEnvironment ParentEnvironment)
        {
            base.Initialize(ParentPlugIn, ParentEnvironment);

            TabAdvancedLevelDetails.Initialize(this, Environment, ParentPlugIn);
            TabSystemInformation.Initialize(this, Environment, ParentPlugIn);
        }

        protected override Gemini.Core.BL.Base.MethodResult DoSave()
        {
            Gemini.Core.BL.Base.MethodResult _methodResult = new Gemini.Core.BL.Base.MethodResult();

            TabAdvancedLevelDetails.Save();

            _methodResult = BLZSBELearning.AdvancedLevel.Save(DataManager.Current);

            return _methodResult;
        }

        protected override bool DoRestore(long? ID)
        {
            bool _result = false;
            BL.BO.AdvancedLevel _AdvancedLevel = BLZSBELearning.AdvancedLevel.Restore(ID);
            if (_AdvancedLevel != null)
            {
                _result = true;
                DataManager.LoadData(null, null, _AdvancedLevel);
                TabAdvancedLevelDetails.Restore();
            }

            return _result;
        }

        protected override bool DoConfirmDelete()
        {
            bool _return = false;
            return _return;
        }
    }
}
